/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.ui.i18n.I18nKey;
import technology.rocketjump.undermount.ui.i18n.I18nWordClass;

public class I18nWord {
    private final String key;
    private Map<I18nWordClass, Map<Gender, String>> wordMap = new EnumMap<I18nWordClass, Map<Gender, String>>(I18nWordClass.class);
    private final List<I18nWordClass> priorityOfDefault = Arrays.asList(I18nWordClass.NOUN, I18nWordClass.VERB, I18nWordClass.ADJECTIVE, I18nWordClass.UNSPECIFIED);

    public I18nWord(String key) {
        this.key = key;
        for (I18nWordClass wordClass : I18nWordClass.values()) {
            this.wordMap.put(wordClass, new EnumMap(Gender.class));
        }
    }

    public I18nWord(String key, String value) {
        this(key);
        this.add(new I18nKey(key), value);
    }

    public void add(I18nKey key, String translatedValue) {
        Map<Gender, String> genderMap = this.wordMap.get((Object)key.wordClass);
        genderMap.put(key.gender, translatedValue);
        genderMap.put(Gender.ANY, translatedValue);
    }

    public String get(I18nWordClass wordClass) {
        return this.get(wordClass, Gender.ANY);
    }

    public String get(I18nWordClass wordClass, Gender gender) {
        String value;
        Map<Gender, String> byWordClass = this.wordMap.get((Object)wordClass);
        if (byWordClass.isEmpty()) {
            I18nWordClass otherWordClass;
            Iterator<I18nWordClass> iterator = this.priorityOfDefault.iterator();
            while (iterator.hasNext() && (byWordClass = this.wordMap.get((Object)(otherWordClass = iterator.next()))).isEmpty()) {
            }
        }
        if (!Gender.ANY.equals((Object)gender) && !byWordClass.containsKey((Object)gender)) {
            gender = Gender.ANY;
        }
        if ((value = byWordClass.get((Object)gender)) == null) {
            return this.key;
        }
        return value;
    }
}

